/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.screens.widgets;

import java.util.ArrayList;
import java.util.List;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import me.srrapero720.waterframes.common.screens.styles.IconStyles;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import org.watermedia.api.image.ImageCache;
import org.watermedia.api.player.PlayerAPI;
import team.creative.creativecore.common.gui.controls.simple.GuiIcon;
import team.creative.creativecore.common.gui.style.Icon;

public class WidgetStatusIcon
extends GuiIcon {
    Icon lastIcon;
    private final DisplayTile tile;

    public WidgetStatusIcon(String name, Icon icon, DisplayTile tile) {
        super(name, icon);
        this.tile = tile;
    }

    public void tick() {
        if (!this.isClient()) {
            return;
        }
        this.setTooltip(this.getStatusTooltip());
        this.setIcon(this.getStatusIcon());
        super.tick();
    }

    @Environment(value=EnvType.CLIENT)
    public List<class_2561> getStatusTooltip() {
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        if (!this.tile.data.active) {
            tooltip.add((class_2561)WidgetStatusIcon.translatable((String)"waterframes.status", (Object[])new Object[]{class_124.field_1061 + WidgetStatusIcon.translate((String)"waterframes.status.off")}));
            tooltip.add((class_2561)WidgetStatusIcon.translatable((String)"waterframes.status.off.desc"));
            return tooltip;
        }
        if (this.tile.imageCache == null && !this.tile.data.hasUri()) {
            tooltip.add((class_2561)WidgetStatusIcon.translatable((String)"waterframes.status", (Object[])new Object[]{class_124.field_1075 + WidgetStatusIcon.translate((String)"waterframes.status.idle")}));
            tooltip.add((class_2561)WidgetStatusIcon.translatable((String)"waterframes.status.idle.desc"));
            return tooltip;
        }
        if (this.tile.imageCache == null) {
            tooltip.add((class_2561)WidgetStatusIcon.translatable((String)"waterframes.status", (Object[])new Object[]{class_124.field_1061 + WidgetStatusIcon.translate((String)"waterframes.status.loading")}));
            return tooltip;
        }
        String status = switch (this.tile.imageCache.getStatus()) {
            default -> throw new IncompatibleClassChangeError();
            case ImageCache.Status.READY -> {
                if (this.tile.imageCache.isVideo()) {
                    if (!PlayerAPI.isReady()) {
                        yield class_124.field_1061 + WidgetStatusIcon.translate((String)"waterframes.status.failed.video");
                    }
                    if (this.tile.display != null && this.tile.display.isBuffering()) {
                        yield class_124.field_1054 + WidgetStatusIcon.translate((String)"waterframes.status.buffering");
                    }
                }
                yield class_124.field_1060 + WidgetStatusIcon.translate((String)"waterframes.status.operative");
            }
            case ImageCache.Status.LOADING, ImageCache.Status.WAITING -> class_124.field_1054 + WidgetStatusIcon.translate((String)"waterframes.status.loading");
            case ImageCache.Status.FAILED -> {
                Throwable e = this.tile.imageCache.getException();
                if (e != null) {
                    if (e.getLocalizedMessage() != null && !e.getLocalizedMessage().isEmpty()) {
                        yield class_124.field_1079 + e.getLocalizedMessage();
                    }
                    if (e.getCause() != null && e.getCause().getLocalizedMessage() != null && !e.getCause().getLocalizedMessage().isEmpty()) {
                        yield class_124.field_1079 + e.getCause().getLocalizedMessage();
                    }
                    if (e.getCause() != null) {
                        e = e.getCause();
                    }
                    yield class_124.field_1079 + e.getClass().getSimpleName();
                }
                yield class_124.field_1061 + WidgetStatusIcon.translate((String)"waterframes.download.exception.invalid");
            }
            case ImageCache.Status.FORGOTTEN -> class_124.field_1079 + WidgetStatusIcon.translate((String)"waterframes.status.not_working");
        };
        tooltip.add((class_2561)WidgetStatusIcon.translatable((String)"waterframes.status", (Object[])new Object[]{status}));
        if (this.tile.imageCache.isCache()) {
            tooltip.add((class_2561)WidgetStatusIcon.translatable((String)"waterframes.status.cache").method_27692(class_124.field_1075));
        }
        return tooltip;
    }

    @Environment(value=EnvType.CLIENT)
    public Icon getStatusIcon() {
        if (!this.tile.data.active) {
            return IconStyles.STATUS_OFF;
        }
        if (this.tile.imageCache == null && !this.tile.data.hasUri()) {
            return IconStyles.STATUS_IDLE;
        }
        if (this.tile.imageCache == null) {
            return IconStyles.STATUS_LOADING;
        }
        return switch (this.tile.imageCache.getStatus()) {
            default -> throw new IncompatibleClassChangeError();
            case ImageCache.Status.READY -> {
                if (this.tile.imageCache.isVideo()) {
                    if (!PlayerAPI.isReady()) {
                        yield IconStyles.STATUS_INTERNAL_ERROR_2;
                    }
                    if (this.tile.display != null && this.tile.display.isBuffering()) {
                        yield IconStyles.STATUS_BUFFERING;
                    }
                }
                if (this.tile.imageCache.isCache()) {
                    yield IconStyles.STATUS_OK_CACHE;
                }
                yield IconStyles.STATUS_OK;
            }
            case ImageCache.Status.LOADING, ImageCache.Status.WAITING -> IconStyles.STATUS_LOADING;
            case ImageCache.Status.FAILED -> IconStyles.STATUS_ERROR;
            case ImageCache.Status.FORGOTTEN -> this.lastIcon == null ? IconStyles.STATUS_WARN : this.lastIcon;
        };
    }
}

